import _ from 'lodash';

import React, { Component } from 'react';
import { FormattedRelative } from 'react-intl';
import PropTypes from 'prop-types';

import Tag from './Tag';

export default class AnnotationsDocumentsTableRow extends Component {
  tags() {
    const { document, topics, metacategories } = this.props;

    const tags = _.chain(document.annotations)
      .map('tags')
      .flatten()
      .uniq()
      .value();

    return tags.map(t => <span className="mr-1 mb-1" key={`${document.uri}_${t}`}><Tag tag={t} categories={topics} metacategories={metacategories} /></span>);
  }

  render() {
    const { document, viaBaseUrl } = this.props;

    const {
      uri,
      name,
      updated,
      usersNb,
      annotationsNb,
    } = document;

    return (
      <tr>
        <td className="text-muted small"><FormattedRelative value={updated} /></td>
        <td>
          <p><a href={uri}>{ name }</a></p>
          <p>{ this.tags() }</p>
        </td>
        <td>{ usersNb }</td>
        <td>{ annotationsNb }</td>
        <td>
          <a href={viaBaseUrl + uri} target="_blank" rel="noopener noreferrer">#</a>
        </td>
      </tr>
    );
  }
}

AnnotationsDocumentsTableRow.propTypes = {
  document: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  topics: PropTypes.arrayOf(PropTypes.string).isRequired,
  viaBaseUrl: PropTypes.string.isRequired,
};
