import React from 'react';
import PropTypes from 'prop-types';

import { FormattedMessage } from 'react-intl';
import { NavLink } from 'react-router-dom';

import { categoryStyles } from '../utils';

const Tag = ({ tag, categories, metacategories }) => {
  let style = '';

  let tagStr = tag.startsWith('cat:') ? tag.substring(4) : tag;
  const tagStrLc = tagStr.toLowerCase();

  let cl = 'badge';

  if (categories.includes(tag)) {
    style = 'topic';
  }

  let metacategory = false;
  if (tag.startsWith('cat:')) {
    metacategory = metacategories.find(mc => mc.tag === tagStrLc);
  }
  if (metacategory) {
    cl += ` badge-primary badge-${metacategory.id}`;
    style = metacategory.id;
    tagStr = <FormattedMessage id={`data.metacategories.${metacategory.id}.label`} />;
  } else {
    cl += ' badge-secondary';
  }

  return (
    <span className="annotation-tag"><NavLink to={`/annotations/${tag}`}><span className={`label badge ${cl}`} style={categoryStyles(style)}>{tagStr}</span></NavLink></span>
  );
};

Tag.propTypes = {
  tag: PropTypes.string.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  categories: PropTypes.arrayOf(PropTypes.string).isRequired,
};

export default Tag;
