import React from 'react';

import { addLocaleData, IntlProvider } from 'react-intl';
import en from 'react-intl/locale-data/en';
import fr from 'react-intl/locale-data/fr';


export default function setIntl(messagesData, WrappedComponent) {
  addLocaleData([...en, ...fr]);

  let language = (navigator.languages && navigator.languages[0])
    || navigator.language
    || navigator.userLanguage;

  let language6391 = language.toLowerCase().split(/[_-]+/)[0];

  if (!(language6391 in messagesData)) {
    language = 'en';
    language6391 = 'en';
  }

  const messages = messagesData[language6391] || messagesData[language] || messagesData.en;

  return props => (
    <IntlProvider
      locale={language}
      messages={messages}
    >
      <WrappedComponent {...props} />
    </IntlProvider>
  );
}
