import React from 'react';
import PropTypes from 'prop-types';

import ReactMarkdown from 'react-markdown';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

import AnnotationQuote from './AnnotationQuote';

import './DefinitionBlock.scss';

const DefinitionHeaderIcon = ({ annotation }) => {
  const annotationText = annotation.text || '';
  let faIconName;

  if (annotationText) {
    faIconName = 'user';
  } else if (/^https?:\/\/.+\.wikipedia\.org/.test(annotation.uri)) {
    faIconName = ['fab', 'wikipedia-w'];
  } else {
    faIconName = 'globe';
  }

  return <FontAwesomeIcon icon={faIconName} className="annotation-card-definition-icon" />;
};

DefinitionHeaderIcon.propTypes = {
  annotation: PropTypes.object.isRequired,
};

const DefinitionUser = ({ annotation }) => {
  const [userName] = annotation.user.replace('acct:', '').split('@');

  return (
    <strong>
      { userName }
      {/* <span className="text-muted">@{ instanceName }</span> */}
    </strong>
  );
};

DefinitionUser.propTypes = {
  annotation: PropTypes.object.isRequired,
};

const DefinitionBody = ({ annotation, metacategories }) => {
  if (annotation.text) {
    return <ReactMarkdown source={annotation.text} />;
  }
  return <AnnotationQuote annotation={annotation} metacategories={metacategories} />;
};

DefinitionBody.propTypes = {
  annotation: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
};


const DefinitionBlock = ({ annotation, metacategories }) => {
  const { document } = annotation;

  return (
    <div className="card definition-card">
      <div className="card-header">
        <DefinitionHeaderIcon annotation={annotation} />
      </div>
      <div className="card-body small">
        <DefinitionBody annotation={annotation} metacategories={metacategories} />
      </div>
      <div className="card-footer">
        <a href={annotation.links.incontext} target="_blank" rel="noopener noreferrer">{ document.title }</a>
        <div>
          <DefinitionUser annotation={annotation} />
        </div>
      </div>
    </div>
  );
};

DefinitionBlock.propTypes = {
  annotation: PropTypes.object.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
};

export default DefinitionBlock;
