import React, { Component } from 'react';
import PropTypes from 'prop-types';
import md5 from 'md5';

import './IndexEntryItem.scss';

export default class IndexEntryItem extends Component {
  static propTypes = {
    term: PropTypes.string,
  };

  static defaultProps = {
    term: '',
  };

  constructor(props) {
    super(props);
    this.linkClick = this.linkClick.bind(this);
  }

  linkClick(e) {
    const { term } = this.props;
    document.getElementById(`${md5(term)}-term-entry`).scrollIntoView();
    e.preventDefault();
  }

  render() {
    const { term } = this.props;
    return <li><button onClick={this.linkClick} type="button" className="btn btn-link index-entry-item__btn">{ term }</button></li>;
  }
}
