import React from 'react';
import { FormattedMessage } from 'react-intl';
import PropTypes from 'prop-types';

import Tag from './Tag';

import './Sidebar.scss';

const TopicsList = ({ topics, metacategories }) => (
  <div>
    <h3 className="title-topics">
      <FormattedMessage
        id="sidebar.categories_title"
        defaultMessage="Categories"
      />
    </h3>

    <p>
      <FormattedMessage
        id="sidebar.categories_desc"
        defaultMessage="This is the list of tags we are going to focus on in this studies."
      />
    </p>

    <dl>
      {
        (topics || []).map(topic => (
          <div key={topic}>
            <dt><Tag tag={topic} categories={topics} metacategories={metacategories} /></dt>
          </div>
        ))
      }
    </dl>
  </div>
);

TopicsList.propTypes = {
  metacategories: PropTypes.arrayOf(PropTypes.object),
  topics: PropTypes.arrayOf(PropTypes.string),
};

TopicsList.defaultProps = {
  metacategories: [],
  topics: [],
};

const MetacategoriesList = ({ topics, metacategories }) => (
  <div>
    <h3>
      <FormattedMessage
        id="sidebar.annotation_protocol"
        defaultMessage="Annotation Protocol"
      />
    </h3>
    {
      (metacategories || []).map((metacategory) => {
        const descId = `data.metacategories.${metacategory.id}.desc`;
        return (
          <div key={metacategory.tag} className="sidebar-metacategories-entry">
            <dt><Tag tag={`cat:${metacategory.tag}`} categories={topics} metacategories={metacategories} /></dt>
            <div className="small"><FormattedMessage id={descId} /></div>
          </div>
        );
      })
    }
  </div>
);

MetacategoriesList.propTypes = {
  metacategories: PropTypes.arrayOf(PropTypes.object),
  topics: PropTypes.arrayOf(PropTypes.string),
};

MetacategoriesList.defaultProps = {
  metacategories: [],
  topics: [],
};

const Sidebar = ({ metacategories, topics }) => (
  <div>
    <MetacategoriesList metacategories={metacategories} topics={topics} />
    <TopicsList metacategories={metacategories} topics={topics} />
  </div>
);

Sidebar.propTypes = {
  metacategories: PropTypes.arrayOf(PropTypes.object),
  topics: PropTypes.arrayOf(PropTypes.string),
};

Sidebar.defaultProps = {
  metacategories: [],
  topics: [],
};

export default Sidebar;
