import requests
import json

QUERY_GROUP = "gVjA5P3n"
GROUP = "Ri4iq687"

USER_TOKENS = {
    'acct:taniki@hypothes.is': ('acct:taniki@h.projet-episteme.org', '6879-zc5yIYGFH7bovEATVDl0HL_CeNhHZYWk07wpoLQs5Ng'),
    'acct:Iness21@hypothes.is': ('acct:Iness21@h.projet-episteme.org', '6879-y_H0QeS2laEZ09VK6KesdKzE2e0IIxyuq5kwIuckeOw'),
    'acct:vincentpuig@hypothes.is': ('acct:vincentpuig@h.projet-episteme.org', '6879-8G7dNqQCdcRxrb4ejjwJuNKVIE5hKvOFhNpntwvvcO4')
}

DEFAULT_TOKEN = "6879-8G7dNqQCdcRxrb4ejjwJuNKVIE5hKvOFhNpntwvvcO4"

TAGS_MAP = {
    '==': 'cat:commentaire',
    '!!': 'cat:important',
    '++': 'cat:important',
    '+glossary': 'cat:mot-clef',
    '??': 'cat:trouble'
}



def query_hypothesis(token=DEFAULT_TOKEN):
    '''
    query hypothesis
    '''
    url = 'https://hypothes.is/api/search'
    headers = {
        "Authorization" : "Bearer 6879-03KAAUnasiHITuFDIbGD9QsEu405TF4e8EREEdYrUek"
        # "Authorization" : "Bearer %s" % token
    }

    params = {
        # "group": "gVjA5P3n",
        "group": QUERY_GROUP,
        "limit": 200
    }

    res = requests.get(url, params=params, headers=headers)
    return res.json()


def json_annotation(annot, user):

    tags = [TAGS_MAP.get(t, t) for t in annot.get('tags', [])]

    return {
        "group": GROUP,
        "tags": tags,
        "target": annot['target'],
        "text": annot['text'],
        "uri": annot['uri'],
        "document": annot['document'],
        "permissions": {
            "read": [
                "group:" + GROUP
            ],
            "admin": [
                user
            ],
            "update": [
                user
            ],
            "delete": [
                user
            ]
        }
    }

def make_annotation(json_annot, token):

    url = 'https://h.projet-episteme.org/api/annotations'


    headers = {
        "Authorization" : "Bearer %s" % token,
        'Content-type': 'application/json'
    }

    data_str = json.dumps(json_annot)
    print("Create annotation %s" % data_str)
    res = requests.post(url, data=data_str, headers=headers)
    print("Annotation created %r" % res)
    # print("%r"%json_annot)
    print("\n")


def delete_annotation(annotation_id, token):
    url = 'https://h.projet-episteme.org/api/annotations/%s' % annotation_id

    headers = {
        "Authorization" : "Bearer %s" % token,
    }

    res = requests.delete(url, headers=headers)


if __name__ == "__main__":

    res_annotations = query_hypothesis()

    # for k, (v, t) in USER_TOKENS.items():
    #     # print("USER %r, %r, %r" % (k,v,t))
    #     for annot in query_hypothesis(t)['rows']:
    #         print("ID %r - %r" % (repr(annot['id']), repr(annot['uri'])))
    #         delete_annotation(annot['id'], t)

    # import json
    # with open('res_annotations2.txt', 'w') as outfile:
    #     json.dump(res_annotations, outfile, ensure_ascii=False)

    # import json

    # with open('filename.txt', 'r') as f:
    #   array = json.load(f)

    for annot in res_annotations['rows']:
        user_create, token = USER_TOKENS.get(annot.get('user', ''), DEFAULT_TOKEN)
        annot_json = json_annotation(annot, user_create)
        make_annotation(annot_json, token)


