import React, { Component } from 'react';
import PropTypes from 'prop-types';

import { insertScript, removeScript } from '../utils';

import './IssoThread.scss';

export default class IssoThread extends Component {
  static propTypes = {
    pathname: PropTypes.string,
    issoId: PropTypes.string.isRequired,
    discussionUrl: PropTypes.string.isRequired,
    messageId: PropTypes.string,
  }

  static defaultProps = {
    pathname: '',
    messageId: '',
  };


  componentWillMount() {
  }

  componentDidMount() {
    const { discussionUrl, pathname } = this.props;
    const jsFile = process.env.NODE_ENV === 'production' ? 'embed.js' : 'embed.dev.js';
    insertScript(
      `${discussionUrl}js/${jsFile}`,
      'isso-js',
      document.body,
      {
        'data-isso-base-location': `#${pathname}/`,
        'data-isso-vote': false,
      },
    );
  }

  componentWillUnmount() {
    removeScript('isso-js', document.body);
  }

  render() {
    const { issoId, messageId } = this.props;
    return <section id="isso-thread" ref={(el) => { this.el = el; }} data-isso-id={issoId} data-isso-target-message={messageId} />;
  }
}
