#!/usr/bin/env bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
SCRIPTNAME=`basename "$0"`

usage() {
  echo -n "${SCRIPTNAME} [DASHBOARDNAME] [VERSION]

Deploy the <DASHBOARDNAME> using ansible.
DASHBOARDNAME must be in the following list : explorunivers_test
"
}

if [[ "$#" -ne 2 ]]; then
    usage
    exit 1
fi

DASHBOARDNAME=${1}
VERSION=${2}

case $DASHBOARDNAME in
    explorunivers_test) DASHBOARDNAMEOK=true;;
    *)             DASHBOARDNAMEOK=false;;
esac

if [[ "$DASHBOARDNAMEOK" = false ]]; then
    usage
    exit 1
fi

pushd "$SCRIPTPATH"

ansible-playbook -v -i "./hosts.$DASHBOARDNAME" -l "$DASHBOARDNAME" ./deploy.yml --extra-vars "dashboard_version=${VERSION}" --ask-vault-pass

popd
