import React from 'react';
import PropTypes from 'prop-types';
import { FormattedMessage, injectIntl, intlShape } from 'react-intl';

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

import './Document.scss';

const Document = ({
  document,
  stats,
  viaBaseUrl,
  intl,
}) => {
  const docStats = stats
    || {
      users: 0,
      annotations: 0,
      comments: 0,
      calls: 0,
    };

  const nbUsersTitle = intl.formatMessage({ id: 'ui.document.nbUsersTitle', defaultMessage: 'Nb. utilisateurs' });
  const nbAnnotationsTitle = intl.formatMessage({ id: 'ui.document.nbAnnotationsTitle', defaultMessage: 'Nb. annotations' });
  const nbCommentsTitle = intl.formatMessage({ id: 'ui.document.nbCommentsTitle', defaultMessage: 'Nb. commentaires' });
  const nbCallsTitle = intl.formatMessage({ id: 'ui.document.nbCallsTitle', defaultMessage: "Nb. d'appels" });

  /* eslint-disable react/no-danger */
  return (
    <div className="card w-100 document-card">

      <div className="card-body">
        <h4 className="card-title">{ document.name }</h4>
        <h6 className="card-subtitle mb-2 text-muted">{ document.author }</h6>

        <p className="card-text small" dangerouslySetInnerHTML={{ __html: document.description }} />

        <a href={viaBaseUrl + document.uri} className="card-link" target="_blank" rel="noopener noreferrer"><FormattedMessage id="ui.document.annotator_link" defaultMessage="Open with annotator" /></a>
      </div>

      <div className="card-footer">
        <div className="stats text-muted small">
          <span title={nbUsersTitle}>
            <FontAwesomeIcon icon="user" />
            {' '}
            <span>{ docStats.users }</span>
          </span>
          <span title={nbAnnotationsTitle}>
            <FontAwesomeIcon icon="pencil-alt" />
            {' '}
            <span>{ docStats.annotations }</span>
          </span>
          <span title={nbCommentsTitle}>
            <FontAwesomeIcon icon="comment" />
            {' '}
            <span>{ docStats.comments }</span>
          </span>
          <span title={nbCallsTitle}>
            <FontAwesomeIcon icon="bell" />
            {' '}
            <span>{ docStats.calls }</span>
          </span>
        </div>
      </div>

    </div>
  );
  /* eslint-enable react/no-danger */
};

Document.propTypes = {
  document: PropTypes.object.isRequired,
  stats: PropTypes.object,
  viaBaseUrl: PropTypes.string.isRequired,
  intl: intlShape.isRequired,
};

Document.defaultProps = {
  stats: {
    users: 0,
    annotations: 0,
    comments: 0,
    calls: 0,
  },
};

export default injectIntl(Document);
