import React from 'react';
import { Route } from 'react-router-dom';
import PropTypes from 'prop-types';

import Loader from '../ui/Loader';
import MainNav from '../ui/MainNav';

const DefaultLayout = ({
  // eslint-disable-next-line react/prop-types
  component: Component,
  title,
  version,
  ...rest
}) => (
  <Route
    {...rest}
    render={matchProps => (
      <div>
        <Loader />
        <div className="container">
          <h1 className="mb-5 mt-5">{ title }</h1>
          <MainNav />
          <Component {...matchProps} {...rest} />
        </div>
        <footer className="text-center text-muted small mt-3 mb-3">
          {`v. ${version} - 2017 - `}
          <a href="http://www.iri.centrepompidou.fr">IRI</a>
          {' / '}
          <a href="https://web.hypothes.is">hypothes.is</a>
        </footer>
      </div>
    )}
  />
);

DefaultLayout.propTypes = {
  title: PropTypes.string.isRequired,
  version: PropTypes.string.isRequired,
};

export default DefaultLayout;
