
import React from 'react';
import PropTypes from 'prop-types';

import { FormattedMessage } from 'react-intl';

import DefinitionBlock from './DefinitionBlock';

const DefinitionsCards = ({ annotations, metacategories, children }) => {
  const defBlocks = annotations.map(
    annotation => <DefinitionBlock key={`annotation-${annotation.id}`} annotation={annotation} metacategories={metacategories} />,
  );

  let noDefinitionContent = <FormattedMessage id="ui.definitionCards.noDefinition" defaultMessage="No definition yet" />;

  if (React.Children.count(children) > 0) {
    noDefinitionContent = children;
  }

  return (
    <div className="card-columns">
      { annotations.length === 0 ? noDefinitionContent : defBlocks }
    </div>
  );
};

DefinitionsCards.propTypes = {
  annotations: PropTypes.arrayOf(PropTypes.object),
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  children: PropTypes.node,
};

DefinitionsCards.defaultProps = {
  annotations: [],
  children: null,
};

export default DefinitionsCards;
