import './index.css';

import React from 'react';
import ReactDOM from 'react-dom';
import en from 'react-intl/locale-data/en';
import fr from 'react-intl/locale-data/fr';

import setIntl from 'dashboard-components/lib/intl';

import App from './App';
import registerServiceWorker from './registerServiceWorker';
import setStore from './store';

const ComposedApp = setIntl({}, setStore(App), [...en, ...fr]);
ReactDOM.render(<ComposedApp />, document.getElementById('root'));
registerServiceWorker();
