import React from 'react';

import DefaultLayout from './DefaultLayout';
import Sidebar from '../ui/Sidebar';

const DefaultLayoutSidebar = ({
  component: Component,
  ...rest
}) => (
  <DefaultLayout
    {...rest}
    component={matchProps => (
      <div className="row">
        <div className="col col-3">
          <Sidebar {...rest} />
        </div>
        <div className="col col-9">
          <Component {...matchProps} />
        </div>
      </div>
    )}
  />
);

export default DefaultLayoutSidebar;
