import React, { Component } from 'react';
import PropTypes from 'prop-types';

import { connect } from 'react-redux';

import Nanobar from 'nanobar';

import './Loader.scss';

export class LoaderComponent extends Component {
  componentDidMount() {
    const opt = {
      id: 'bar-main',
      target: document.getElementById('nanobar'),
    };

    this.nanobar = new Nanobar(opt);

    // this.nanobar.go(10);
  }

  componentDidUpdate() {
    const { go } = this.props;
    this.nanobar.go(go);
  }

  render() {
    return <div id="nanobar" />;
  }
}


LoaderComponent.propTypes = {
  go: PropTypes.number.isRequired,
};

export default connect(
  (state) => {
    switch (state.annotations.isFetching) {
      case true:
        return { go: 50 };

      case false:
        return { go: 100 };
      default:
        return {};
    }
  },
)(LoaderComponent);
