import React from 'react';

import { HashRouter } from 'react-router-dom';

import { DefaultLayoutSidebar, DefaultLayout } from 'dashboard-components/lib/layouts';

import {
  DocumentsPage,
  GlossaryPage,
  ChartsPage,
  AnnotationsPage,
  TermPage,
} from 'dashboard-components/lib/pages';

import { ScrollToTop } from 'dashboard-components/lib/ui';

import config from './config.json';

const version = process.env.REACT_APP_VERSION;
const viaBaseUrl = process.env.REACT_APP_VIA_BASE_URL;
const discussionUrl = process.env.REACT_APP_DISCUSSION_URL;
const {
  metacategories,
  topics,
  documents,
  title,
  dashboardId,
} = config;

const App = () => (
  <HashRouter>
    <ScrollToTop>
      <div>
        <DefaultLayoutSidebar
          exact
          path="/"
          component={DocumentsPage}
          version={version}
          metacategories={metacategories}
          topics={topics}
          documentsMap={documents}
          viaBaseUrl={viaBaseUrl}
          title={title}
        />
        <DefaultLayout
          path="/glossary"
          component={GlossaryPage}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/charts"
          component={ChartsPage}
          metacategories={metacategories}
          topics={topics}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/annotations/:tagName?"
          component={AnnotationsPage}
          metacategories={metacategories}
          topics={topics}
          viaBaseUrl={viaBaseUrl}
          title={title}
          version={version}
        />
        <DefaultLayoutSidebar
          path="/term/:term/:activeTab?/:messageId?"
          component={TermPage}
          title={title}
          viaBaseUrl={viaBaseUrl}
          metacategories={metacategories}
          topics={topics}
          version={version}
          discussionUrl={discussionUrl}
          dashboardId={dashboardId}
        />
      </div>
    </ScrollToTop>
  </HashRouter>
);

export default App;
