import React from 'react';
import { NavLink } from 'react-router-dom';
import { FormattedMessage } from 'react-intl';

const MainNav = () => (
  <nav className="navbar navbar-expand-lg navbar-light bg-light mb-3">
    <ul className="navbar-nav mr-auto">
      <li className="nav-item"><NavLink exact className="nav-link" activeClassName="active" to="/" replace><FormattedMessage id="main-nav.menu.documents" defaultMessage="Documents" /></NavLink></li>
      <li className="nav-item"><NavLink className="nav-link" activeClassName="active" to="/glossary" replace><FormattedMessage id="main-nav.menu.glossary" defaultMessage="Glossary" /></NavLink></li>
      <li className="nav-item"><NavLink className="nav-link" activeClassName="active" to="/charts" replace><FormattedMessage id="main-nav.menu.charts" defaultMessage="Charts" /></NavLink></li>
    </ul>
  </nav>
);

export default MainNav;
