import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import _ from 'lodash';
import AnnotationsCards from '../ui/AnnotationsCards';

const AnnotationsPage = ({
  annotations,
  viaBaseUrl,
  metacategories,
  topics,
}) => (
  <AnnotationsCards
    annotations={annotations}
    viaBaseUrl={viaBaseUrl}
    metacategories={metacategories}
    categories={topics}
  />
);

AnnotationsPage.propTypes = {
  // title: PropTypes.string,
  annotations: PropTypes.array.isRequired,
  viaBaseUrl: PropTypes.string.isRequired,
  metacategories: PropTypes.arrayOf(PropTypes.object).isRequired,
  topics: PropTypes.arrayOf(PropTypes.string).isRequired,
};

export default connect(
  (state, props) => {
    let annotations = state.annotations.items;
    let tag = (props.match.params || {}).tagName;
    if (tag) {
      tag = tag.toLowerCase();
      annotations = _.filter(
        annotations,
        annot => _.find(
          annot.tags,
          t => t.toLowerCase() === tag,
        ),
      );
    }
    return {
      annotations,
    };
  },
)(AnnotationsPage);
