(function(){
  'use strict';

  angular.module('ammicoSlideshow',['ngResource', 'ngRoute', 'ui.bootstrap'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'slideshow/slideshow.html',
          controller: 'slideshowCtrl'
        });
    })
    .service('slideshowModel', function(searchApi) {
      console.log('slideshow 6',this);
      this.slideshow = searchApi.searchResource({q:'stop_email=toto@gmail.com', of: 'json', synthesis: 'false', nresults:'50', callback: 'JSON_CALLBACK'}).getJsonp();
    })
    .controller('slideshowCtrl', function($scope, $filter, $location, $routeParams, $timeout, searchApi, slideshowModel){
      //console.log('slideshow 7', $location, $routeParams, searchApi);
      console.log('slideshow 7');
      $scope.slideshow = slideshowModel.slideshow;
      
      $scope.iSlide = parseInt($routeParams.iSlide) || 0;
      //console.log('$routeParams',$routeParams);
      if(typeof $routeParams.searched !== 'undefined'){
          var a = $routeParams.searched.split(',');
          var q = a[0], i = parseInt(a[1]);
          if(a.length===2 && !isNaN(i)){
              searchApi.searchResource({q:q, of: 'json', synthesis: 'false', nresults:'50', callback: 'JSON_CALLBACK'}).getJsonp().$promise.then(
                  //success
                  function( data ){
                      $scope.slideshow.hits.push(data.hits[i]);
                      // timeout because
                      $timeout(function(){$scope.slideshow.hits[$scope.slideshow.hits.length-1].active = true;}, 500);
                  },
                  //error
                  function( error ){
                      alert('Erreur avec la requête (dans slideshow)', error);
                  }
              );
          }
      }
      $timeout(function(){
          if($scope.iSlide>=0 && $scope.iSlide<$scope.slideshow.hits.length){
              $scope.slideshow.hits[$scope.iSlide].active = true;
              var l = $location.path();
              if(l.substr(0,16)==='/slideshow/edit/'){
                  $scope.slideshow.hits[$scope.iSlide].editMode = true;
              }
          }
      }, 500);
      
      $scope.save = function(){
          //console.log('8 call save POST',$scope.slideshow);
          $scope.slideshow
          .$save()
          .then(
              function(response) {
                  console.log('NICE SAVING!', response);
              },
              function(reason){
                  alert('An error occured while saving : ' + reason);
              }
          );
      };
    })
    .directive('slideEditor', function() {
      return {
          restrict: 'AE',
          replace: true,
          scope: false,
          templateUrl: 'slideshow/dataEditor.html',
          //controller: function($scope, $element, $attrs){
          controller: function($scope){
              $scope.slidesave = function(){
                  if(typeof $scope.slide.tags === 'string'){
                      $scope.slide.tags = $scope.slide.tags.split(',');
                  }
                  for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
                      $scope.slide.tags[i] = $scope.slide.tags[i].trim();
                  }
                  $scope.slide.editMode = false;
                  $scope.save();
              };
              $scope.editSlidesave = function(){
                  if(typeof $scope.slide.tags === 'string'){
                      $scope.slide.tags = $scope.slide.tags.split(',');
                  }
                  for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
                      $scope.slide.tags[i] = $scope.slide.tags[i].trim();
                  }
                  $scope.slide.editMode = false;
                  $scope.save();
              };
          }
      };
  });

})();
