# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings
import taggit.managers
import datetime


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('idArticle', models.CharField(max_length=512, null=True, blank=True)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(max_length=512, null=True, blank=True)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('public', models.BooleanField(default=False, db_index=True)),
                ('parent_visit', models.ForeignKey(null=True, related_name='books_copy', to='ammico.Book', blank=True)),
                ('user', models.ForeignKey(to=settings.AUTH_USER_MODEL, related_name='books')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('idStop', models.CharField(max_length=512, blank=True)),
                ('idInventory', models.CharField(max_length=512, blank=True)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(max_length=1024, blank=True)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('favorite', models.BooleanField(default=False, db_index=True)),
                ('book', models.ForeignKey(to='ammico.Book', related_name='slides')),
                ('tags', taggit.managers.TaggableManager(through='taggit.TaggedItem', help_text='A comma-separated list of tags.', to='taggit.Tag', verbose_name='Tags', blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterOrderWithRespectTo(
            name='slide',
            order_with_respect_to='book',
        ),
    ]
