(function(){
  'use strict';

  angular.module('ammico', [ 'ngRoute','ammicoHome', 'ammicoBooks', 'ammicoSlides', 'ammicoSlideshow', 'ammicoSearch', 'ammicoAuth', 'templates' ])
    .config(function($routeProvider) {
      $routeProvider.
        when('/', {
        controller: 'homeCtrl',
        templateUrl: 'home/home.html'
      }).
      when('/books', {
          controller: 'booksCtrl',
          templateUrl: 'books/books.html'
      }).
      when('/books/:idBook', {
        controller: 'bookCtrl',
        templateUrl: 'books/book.html'
      }).
      when('/slide/:idSlide', {
          controller: 'slidesCtrl',
          templateUrl: 'slides/slides.html'
       }).
      when('/slideshow/', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/:iSlide', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/edit/:iSlide', {
          controller: 'slideshowCtrl',
          templateUrl: 'slideshow/slideshow.html'
      }).
      when('/slideshow/add/:searched', {
        controller: 'slideshowCtrl',
        templateUrl: 'slideshow/slideshow.html'
      }).
      when('/search', {
          controller: 'searchCtrl',
          templateUrl: 'search/search.html'
      }).
      when('/search/:q', {
          controller: 'searchCtrl',
          templateUrl: 'search/search.html'
      }).
      when('/login', {
          controller: 'authCtrl',
          templateUrl: 'auth/auth.html'
      }).
      otherwise({
        redirectTo: '/'
      });
    })
    // .config(function ($routeProvider) {
    //   $routeProvider
    //     .otherwise({
    //       redirectTo: '/'
    //   });
    // });
    .config(function($logProvider){
      $logProvider.debugEnabled(true);
    })
    .service('searchApi', function($resource, context, $sce) {
        this.searchResource = function(params){
            return $resource(context.urls.searchUrl,  
                {
                    callback: 'JSON_CALLBACK'
                },
                {
                    getJsonp: {
                        method: 'JSONP',
                        params: params,
                        isArray: false,
                        transformResponse: function(data){
                            // Transform meta list into meta dict
                            var nb = data.hits.length;
                            for(var i=0;i<nb;i++){
                                var nb_metas = data.hits[i].metas.length;
                                data.hits[i].metas_dict = {};
                                for(var j=0;j<nb_metas;j++){
                                    if(typeof data.hits[i].metas[j].images==='undefined'){
                                        data.hits[i].metas_dict[data.hits[i].metas[j].name] = data.hits[i].metas[j].value;
                                    }
                                    else{
                                        data.hits[i].metas_dict.images = data.hits[i].metas[j].images[0].value;
                                    }
                                }
                            }
                            return data;
                        }
                    }
                });
        };
        this.listBooks = $resource(context.urls.ammicoUrl+'/books/');
        this.book = $resource(context.urls.ammicoUrl+'/books/:idBook/', {idBook:'@idBook'});
        this.booksSlides = $resource(context.urls.ammicoUrl+'/books/:idBook/slides/', {idBook:'@idBook'});
        this.listSlides= $resource(context.urls.ammicoUrl+'/slides/');
        this.slide = $resource(context.urls.ammicoUrl+'/slides/:idSlide/', {idSlide:'@idSlide'});
        this.sanitizeUrls = function(data){
        	console.log('heyr there !');
        	console.log(data);
        	data.details.audio = $sce.trustAsResourceUrl(data.details.audio);
        	data.details.video = $sce.trustAsResourceUrl(data.details.video);
        	data.audio = $sce.trustAsResourceUrl(data.audio);
        	data.video = $sce.trustAsResourceUrl(data.video);
        	return data;
        };
    });

})();
