(function(){
	'use strict';

	angular.module('ammicoBooks',['ngRoute'])
	.service('booksModel', function(searchApi) {
		this.books = searchApi.listBooks.query({format:'json'}); 
	})
	.controller('booksCtrl', function($scope, $location, booksModel){
		$scope.books = booksModel.books;
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};
	})
	.controller('bookCtrl', function($scope, searchApi, $routeParams, booksModel) {
		$scope.slides = searchApi.booksSlides.query({idBook:$routeParams.idBook, format:'json'}, function(data){
			if (typeof(booksModel.slide) === 'undefined')
				booksModel.slides = []; 
			booksModel.slides[$routeParams.idBook] = data;
		});

		$scope.deleteItem = function(i){
			if(0<=i && i<$scope.slides.length){
				if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
					searchApi.slide.delete({idSlide: $scope.slides[i].id}, function(res){
						if (res.status === '200'){
							$scope.slides.splice(i, 1);
						}
					});
				}
			}
		};
	});
})();
