(function(){
	'use strict';

	angular.module('ammicoBooks',['ngRoute', 'ui.sortable'])
	.controller('booksCtrl', function($scope, $location, $modal, ammicoApi){
		$scope.books = ammicoApi.listBooks.query({format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.date < b.date;
			});
		});
		
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};

		$scope.addBook = function (idParent) {
			$modal.open({
				templateUrl: 'books/add_modal.html',
				controller: 'ModalAddBookCtrl'
			}).result.then(function (title) {
				ammicoApi.listBooks.save({idParent:idParent, title: title}, function(newBook){
					$scope.books.push(newBook);
				});
			});
		};
		$scope.deleteItem = function(book){
			if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
				ammicoApi.book.delete({idBook: book.id}, function(){
					$scope.books.splice($scope.books.indexOf(book), 1);
				},
				function(error) {
					if (error.status === 404){
						$scope.books.splice($scope.books.indexOf(book), 1);
					}
				});
			}
		};
	})
	.controller('bookCtrl', function($scope, ammicoApi, $routeParams) {
		$scope.slides = ammicoApi.booksSlides.query({idBook:$routeParams.idBook, format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.orderIndex > b.orderIndex;
			});
		});
		$scope.sortableOptions = {
				stop: function() {
					var order = $scope.slides.map(function(i){
						return i.id;
					});
					ammicoApi.order.save({idBook:$routeParams.idBook}, {order: order});
				}
		};

		$scope.deleteItem = function(i){
			if(0<=i && i<$scope.slides.length){
				if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
					ammicoApi.slide.delete({idSlide: $scope.slides[i].id}, function(){
						$scope.slides.splice(i, 1);
					},
					function(error) {
						if (error.status === 404){
							$scope.slides.splice(i, 1);
						}
					});
				}
			}
		};
	})
	.controller('ModalAddBookCtrl', function ($scope, ammicoApi, $modalInstance) {

		$scope.add = function(){
			$modalInstance.close($scope.title);
//			ammicoApi.listBooks.save({title: $scope.title}, function(newBook){
//			});
		};
		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};
	});
})();
