from html.parser import HTMLParser
import json

import requests
from rest_framework import serializers
import xmltodict

from ammico.models import Book, Slide
from ammico.utils import fetchJson
from config import URL_EXALEAD, URL_ORPHEO, URL_JAMESPOT


class BookSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = Book
        fields = ('id', 'user', 'idArticle', 'parent_visit', 'title', 'description', 'image', 'date')
        
class SlideSerializer(serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    index = serializers.SerializerMethodField('getOrder')
    
    def getStopInfo(self, slide):
        if (slide.idInventory != ""):
            return extractFromMIMO(slide)
        else:
            return extractFromOrpheo(slide)
        
    def getOrder(self, slide):
        return slide.book.get_slide_order().index(slide.id)

    class Meta:
        model = Slide
        fields = ('id', 'index', 'book', 'idStop', 'idInventory', 'title', 'description', 'comment', 'image', 'date', 'favorite', 'details')
        

def extractFromMIMO(slide):
    details = {}
    params = {'of': 'json', 'q': 'record_inventorynumber:' + slide.idInventory} 
    data = requests.get(URL_EXALEAD, params=params)
    results = json.loads(data.content.decode('utf-8'))
    if (len(results['hits']) == 1):
        for i in results['hits'][0]['metas']:
            if('images' not in i):
                details[i['name']] = i['value']
            else:
                details['images'] = i['images'][0]['value']           
        details['title'] = details.pop('name')
    return details

def extractFromJameSpot(slide):
    details={}
    stopList = fetchJson(URL_JAMESPOT + '&f=list&o=article&type=stop&itemFormat=article')
    for stops in stopList:
        if (slide.idStop == stops['idStop']):
            details = stops
            details['images'] = details.pop('firstImg')
            details['description'] = details.pop('captionImg')
    return details

def extractFromOrpheo(slide):
    details = {}
    params = {'id': slide.idStop.replace('stop-', '')} 
    data = requests.get(URL_ORPHEO, params=params)
    parsed_data = xmltodict.parse(data.content.decode('utf-8'))
    
    if ('item' in parsed_data['result']):
        details = {
            'title': parsed_data['result']['item']['title'],
            'idInventory': parsed_data['result']['item']['Numero_inventaire'],
        }
        parser = MyHTMLParser()
        
        if (parsed_data['result']['item']['Description']):
            parser.feed(parsed_data['result']['item']['Description'])
            details['description']= parser.description
            
        if (parsed_data['result']['item']['Audio']):
            parser.feed(parsed_data['result']['item']['Audio'])
            details['image']= parser.image
            details['audio']= parser.audio
            details['caption']= parser.caption
            
        if (parsed_data['result']['item']['Video']):
            parser.feed(parsed_data['result']['item']['Video'])
            details['video']= parser.video
            details['image']= parser.image
            
        #if (parsed_data['result']['item']['Image']):
        #    parser.feed(parsed_data['result']['item']['Image'])
        #    details['image']= parser.caption
        
    return details

class MyHTMLParser(HTMLParser):
    starttag=''
    endtag=''
    audio=''
    video=''
    image=''
    caption=''
    description=''
    
    def handle_starttag(self, tag, attrs):
        if (self.starttag == 'audio' and tag == 'source'):
            for attr in attrs:
                if 'src' in attr:
                    print(attr)
                    self.audio = attr[1]
        elif (tag == 'img'):
            for attr in attrs:
                if 'src' in attr:
                    self.image = attr[1]
        elif (tag == 'video'):
            for attr in attrs:
                if 'poster' in attr:
                    self.image = attr[1]
        if (self.starttag == 'video' and tag == 'source'):
            for attr in attrs:
                if 'src' in attr:
                    print(attr)
                    self.video = attr[1]
        self.starttag = tag
    def handle_endtag(self, tag):
        self.tag = tag
    def handle_data(self, data):
        self.description = data
