(function(){
  'use strict';

  angular.module('ammicoSearch',['ngResource', 'ngRoute'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'search/search.html',
          controller: 'searchCtrl'
        });
    })
    .controller('searchCtrl', function($scope, $location, $routeParams, searchApi){
      console.log('search 6',$scope, $location, $routeParams);
      $scope.q = $routeParams.q || '';
      searchApi.searchResource({q:$scope.q, of: 'json', synthesis: 'false', nresults:'50', callback: 'JSON_CALLBACK'}).$promise.then(
          //success
          function( data ){
              // Transform meta list into meta dict
              var nb = data.hits.length;
              for(var i=0;i<nb;i++){
                  var nb_metas = data.hits[i].metas.length;
                  data.hits[i].metas_dict = {};
                  for(var j=0;j<nb_metas;j++){
                      if(typeof data.hits[i].metas[j].images==='undefined'){
                          data.hits[i].metas_dict[data.hits[i].metas[j].name] = data.hits[i].metas[j].value;
                      }
                      else{
                          data.hits[i].metas_dict.images = data.hits[i].metas[j].images[0].value;
                      }
                  }
              }
              $scope.results = data;
          },
          //error
          function( error ){
              alert('Erreur avec la requête', error);
          }
      );
    })
    .filter('meta', function() {
        return function(input, metaName) {
            var nb = input.length, i = 0, found = false;
            while(found===false && i<nb){
                if(input[i].name===metaName){
                    found = true;
                    return input[i].value;
                }
                i++;
            }
            return '';
        };
    });

})();
