(function(){
    'use strict';

    angular.module('ammicoMyvisit',['ngRoute', 'ui.sortable'])
    .controller('my_visitCtrl', function($scope, $location, $modal, Book, Slide){

        //get list book
        Book.query({type: 'visit', format:'json'}, function(data){
            data.sort(function (a, b) {
                return a.date > b.date;
            });
            if (data.length >= 1){
                $scope.last_visit = data[0];
                $scope.last_visit.slides = Slide.query({idBook:data[0].id, format:'json'});
            }
        });

        $scope.addBook = function (idParent) {
            $modal.open({
                templateUrl: 'my_visit/add_modal_my_visit.html',
                controller: 'ModalAddMyvisitCtrl'
            }).result.then(function (title) {
                //add book with the title written in the modal
                Book.save({idParent:idParent, title: title}, function(newBook){
                    $scope.books.push(newBook);
                });
            });
        };        
    })
    .controller('ModalAddMyvisitCtrl', function ($scope, $modalInstance) {

        $scope.add = function(){
            $modalInstance.close($scope.title);
        };
        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        };
        $scope.share = function () {
            $modalInstance($scope.book);
        };
    });
})();

