(function(){
	'use strict';

	angular.module('ammicoMyvisit',['ngRoute', 'ui.sortable'])
	.controller('my_visitCtrl', function($scope, $location, $modal, ammicoApi){

		//get list book
		$scope.books = ammicoApi.listBooks.query({format:'json'}, function(data){
			data.sort(function (a, b) {
				return a.date < b.date;
			});

			for (var i = 0; i < data.length; i++) {
		    	if (data[i].idArticle){
		    		data[i].slides = ammicoApi.booksSlides.query({idBook:data[i].id, format:'json'});
		    	}
			}	
		});

		$scope.addBook = function (idParent) {
			$modal.open({
				templateUrl: 'my_visit/add_modal_my_visit.html',
				controller: 'ModalAddMyvisitCtrl'
			}).result.then(function (title) {
				//add book with the title written in the modal
				ammicoApi.listBooks.save({idParent:idParent, title: title}, function(newBook){
					$scope.books.push(newBook);
				});
			});
		};


		$scope.share = function (idParent) {
			$modal.open({
				templateUrl: 'my_visit/share_modal_my_visit.html',
				controller: 'ModalAddMyvisitCtrl'
			}).result.then(function (title) {
				//add book with the title written in the modal
				ammicoApi.slidesBook.query({idParent:idParent, title: title}, function(newBook){
					$scope.books(newBook);
				});
			});
		};

		
	})

	.controller('ModalAddMyvisitCtrl', function ($scope, ammicoApi, $modalInstance) {

		$scope.add = function(){
			$modalInstance.close($scope.title);
//			ammicoApi.listBooks.save({title: $scope.title}, function(newBook){
//			});
		};
		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};
		$scope.share = function () {
			$modalInstance($scope.book);
		};
	});

	


})();

