# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import datetime
import taggit.managers
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID', auto_created=True)),
                ('id_article', models.CharField(null=True, blank=True, max_length=512)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(null=True, blank=True, max_length=512)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('public', models.BooleanField(db_index=True, default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Exposition',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID', auto_created=True)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(max_length=1024, blank=True)),
                ('url_exalead', models.URLField(max_length=2048, blank=True)),
                ('url_orpheo', models.URLField(max_length=2048, blank=True)),
                ('url_jamespot', models.URLField(max_length=2048, blank=True)),
                ('active', models.BooleanField(db_index=True, default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID', auto_created=True)),
                ('id_stop', models.CharField(max_length=512, blank=True)),
                ('id_inventory', models.CharField(max_length=512, blank=True)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(max_length=1024, blank=True)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('favorite', models.BooleanField(db_index=True, default=False)),
                ('book', models.ForeignKey(related_name='slides', to='ammico.Book')),
                ('tags', taggit.managers.TaggableManager(through='taggit.TaggedItem', verbose_name='Tags', to='taggit.Tag', help_text='A comma-separated list of tags.', blank=True)),
            ],
        ),
        migrations.AddField(
            model_name='book',
            name='exposition',
            field=models.ForeignKey(related_name='exposition', to='ammico.Exposition'),
        ),
        migrations.AddField(
            model_name='book',
            name='parent_visit',
            field=models.ForeignKey(to='ammico.Book', null=True, related_name='books_copy', blank=True),
        ),
        migrations.AddField(
            model_name='book',
            name='user',
            field=models.ForeignKey(related_name='books', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterOrderWithRespectTo(
            name='slide',
            order_with_respect_to='book',
        ),
    ]
