from rest_framework import serializers

from ammicosrv.ammico.models import Book, Slide
from ammicosrv.ammico.extractors import extractFromMIMO, extractFromJameSpot
from ammicosrv.ammico.serializers.taggit import TaggitSerializer, TagListSerializerField


class BookSerializer(serializers.ModelSerializer):
    count = serializers.SerializerMethodField('getCount')
    
    def getCount(self, book):
        return book.slides.all().count()
    
    class Meta:
        model = Book
        fields = ('id', 'user', 'id_article', 'parent_visit', 'title', 'description', 'image', 'date', 'count', 'public', 'exposition')
        write_only_fields = ('exposition',)
        
class SlideSerializer(TaggitSerializer, serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    index = serializers.SerializerMethodField('getOrder')
    tags = TagListSerializerField(required=False)
    
    def getStopInfo(self, slide):
        if (slide.research_id != ""):
            #slide added from searched in MIMO database
            return extractFromMIMO(slide)
        else:
            #Get stop info from Oprheo
            #return extractFromOrpheo(slide)
            #Get stop info from Jamespot
            return extractFromJameSpot(slide)
        
    def getOrder(self, slide):
        return slide.book.get_slide_order().index(slide.id)

    class Meta:
        model = Slide
        fields = ('id', 'index', 'book', 'id_stop', 'research_id', 'title', 'description', 'image', 'date', 'favorite', 'tags', 'details')