var gulp = require('gulp');
var gutil = require('gulp-util')
var plugins = require("gulp-load-plugins")({lazy:false});
//var flatten = require('gulp-flatten');
//var uglify = require('gulp-uglify');
//var clean = require('gulp-clean');
//var rename = require('gulp-rename');
//var filesize = require('gulp-filesize');
//var cssmin  = require('gulp-cssmin');

gulp.task('clean', function () {
  return gulp.src('build', {read: false})
    .pipe(clean());
});

var scriptsSrc = ['!./app/**/*_test.js','./app/**/*.js'];

gulp.task('scripts', function(){
    //combine all js files of the app
    gulp.src(scriptsSrc)
        .pipe(plugins.jshint())
        .pipe(plugins.jshint.reporter('default'))
        .pipe(plugins.jshint.reporter('fail'))
        .pipe(plugins.concat('app.js'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .pipe(plugins.uglify())
        .pipe(plugins.rename('app.min.js'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .on('error', gutil.log);
});

gulp.task('templates',function(){
    //combine all template files of the app into a js file
    gulp.src(['!./app/index.html',
        './app/**/*.html'])
        .pipe(plugins.angularTemplatecache('templates.js',{standalone:true}))
        .pipe(gulp.dest('./build'));
});

gulp.task('css', function(){
    gulp.src('./app/**/*.css')
//        .pipe(plugins.csslint())
//        .pipe(plugins.csslint.reporter())
        .pipe(plugins.concat('app.css'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .pipe(plugins.minifyCss({keepBreaks:true}))
        .pipe(plugins.rename('app.min.css'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize());
});

var vendorJSsrc = [
  '!./bower_components/**/*.min.js',
  '!./bower_components/bootstrap/Gruntfile.js',
  '!./bower_components/bootstrap/grunt/*',
  '!./bower_components/bootstrap/js/*',
  '!./bower_components/jquery/src/**/*',
  '!./bower_components/angular-bootstrap/ui-bootstrap.js',
  './bower_components/jquery/dist/jquery.js',
  './bower_components/**/*.js'
];

gulp.task('vendorJS', function(){
    //concatenate vendor JS files
    gulp.src(vendorJSsrc)
        .pipe(plugins.concat('lib.js'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .pipe(plugins.uglify())
        .pipe(plugins.rename('lib.min.js'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .on('error', gutil.log);
});

gulp.task('vendorCSS', function(){
    //concatenate vendor CSS files
    gulp.src(['!./bower_components/**/*.min.css',
        './bower_components/**/*.css'])
        .pipe(plugins.concat('lib.css'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize())
        .pipe(plugins.minifyCss({keepBreaks:true}))
        .pipe(plugins.rename('lib.min.css'))
        .pipe(gulp.dest('./build'))
        .pipe(plugins.filesize());
});

gulp.task('vendorFonts', function(){
    gulp.src(['./bower_components/**/fonts/*'])
        .pipe(plugins.flatten())
        .pipe(gulp.dest('./build/fonts'));
});

gulp.task('copy-index', function() {
    gulp.src('./app/index.html')
        .pipe(gulp.dest('./build'));
});

gulp.task('copy-data', function() {
    gulp.src('./data/**/*')
        .pipe(gulp.dest('./build/data'));
});

gulp.task('copy-img', function() {
    gulp.src('./img/**/*')
        .pipe(gulp.dest('./build/img'));
});

gulp.task('watch',function(){
    gulp.watch([
        'build/**/*.html',
        'build/**/*.js',
        'build/**/*.css'
    ], function(event) {
        return gulp.src(event.path)
            .pipe(plugins.connect.reload());
    });
    gulp.watch(['./app/**/*.js','!./app/**/*test.js'],['scripts']);
    gulp.watch(['!./app/index.html','./app/**/*.html'],['templates']);
    gulp.watch('./app/**/*.css',['css']);
    gulp.watch('./app/index.html',['copy-index']);
    gulp.watch('./data/**/*',['copy-data']);
    gulp.watch('./img/**/*',['copy-img']);

});

gulp.task('connect', plugins.connect.server({
    root: ['build'],
    port: 9000,
    livereload: true
}));

gulp.task('default',['connect','scripts','templates','css','copy-index','copy-data','copy-img','vendorJS','vendorCSS','vendorFonts','watch']);
