(function(){
  'use strict';

  angular.module('ammicoGallery',['ngResource', 'ngRoute'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'gallery/gallery.html',
          controller: 'galleryCtrl'
        });
    })
    .service('galleryApi', function($resource, context) {
      this.gallery = $resource(context.urls.galleryUrl,
        {
          get: {
            method: 'GET',
            isArray: false
          }
        });
    })
    .service('galleryModel', function(galleryApi, context) {
      console.log('4', context.gallery);
      if(typeof context.gallery === 'undefined') {
        console.log('4-1');
        this.gallery = galleryApi.gallery.get();
      }
      else {
        console.log('4-2');
        this.gallery = new galleryApi.gallery(context.gallery);
      }
    })
    .controller('galleryCtrl', function($scope, $location, galleryModel){
      console.log('5',$scope, $location, galleryModel);
      $scope.gallery = galleryModel.gallery;
    });

})();
