(function(){
	'use strict';


	angular.module('ammicoHome',['ngRoute'])
	.config(function ($routeProvider) {
		$routeProvider
		.when('/', {
			templateUrl: 'home/home.html',
			controller: 'homeCtrl'
		});
	})
	.service('booksModel', function(searchApi) {
		var _this = this;
		
		this.books = searchApi.getResource.query({action:'books', format:'json'}, function(data){
			_this.books = data;
		});
	})
	.controller('homeCtrl', function($scope, $location){
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};
	})
	.filter('meta', function() {
		return function(input, metaName) {
			var nb = input.length, i = 0, found = false;
			while(found===false && i<nb){
				if(input[i].name===metaName){
					found = true;
					return input[i].value;
				}
				i++;
			}
			return '';
		};
	});

})();
