# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AmmicoUser',
            fields=[
                ('id', models.AutoField(primary_key=True, auto_created=True, verbose_name='ID', serialize=False)),
                ('idUser', models.CharField(unique=True, max_length=512)),
                ('image', models.URLField(blank=True, max_length=2048)),
                ('user', models.OneToOneField(to=settings.AUTH_USER_MODEL)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(primary_key=True, auto_created=True, verbose_name='ID', serialize=False)),
                ('idArticle', models.CharField(unique=True, max_length=512)),
                ('title', models.CharField(blank=True, max_length=512)),
                ('description', models.CharField(blank=True, max_length=512, null=True)),
                ('image', models.URLField(blank=True, max_length=2048)),
                ('date', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(to='ammico.AmmicoUser')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.AutoField(primary_key=True, auto_created=True, verbose_name='ID', serialize=False)),
                ('idStop', models.CharField(max_length=512)),
                ('title', models.CharField(blank=True, max_length=512)),
                ('description', models.CharField(blank=True, max_length=1024)),
                ('comment', models.CharField(blank=True, max_length=2048)),
                ('image', models.URLField(blank=True, max_length=2048)),
                ('date', models.DateTimeField(blank=True)),
                ('favorite', models.BooleanField(default=False, db_index=True)),
                ('book', models.ForeignKey(related_name='slides', to='ammico.Book')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterOrderWithRespectTo(
            name='slide',
            order_with_respect_to='book',
        ),
    ]
