import datetime

from django.contrib.auth.models import User
from django.db import models
from taggit.managers import TaggableManager


class AmmicoUser(models.Model):
    user = models.OneToOneField(User)
    idUser = models.CharField(max_length=512, unique=True)
    image = models.URLField(max_length=2048, blank=True)
    
    def __str__(self):
        return self.user.username

class Book(models.Model):
    user = models.ForeignKey(AmmicoUser)
    idArticle = models.CharField(max_length=512, unique=True)
    title = models.CharField(max_length=512, blank=True)
    description = models.CharField(max_length=512, blank=True, null=True)
    image = models.URLField(max_length=2048, blank=True)
    date = models.DateTimeField(null=True)
    
    def __str__(self):
        return self.title

class Slide(models.Model):
    book = models.ForeignKey(Book, related_name = "slides")
    idStop = models.CharField(max_length=512, blank=True)
    idInventory = models.CharField(max_length=512, blank=True)
    title = models.CharField(max_length=512, blank=True)
    description = models.CharField(max_length=1024, blank=True)
    comment = models.CharField(max_length=2048, blank=True)
    image = models.URLField(max_length=2048, blank=True)
    date = models.DateTimeField(default=datetime.datetime.now)
    favorite = models.BooleanField(default=False, db_index=True)
    
    def __str__(self):
        return self.idStop
    
    class Meta:
        order_with_respect_to = 'book'