from django.conf.urls import patterns, url, include
from django.views.generic.base import TemplateView

from ammico.views import ListBooks, InfoBook, ListSlides, InfoSlide, SlidesOrder, PublicBooks


urlpatterns = patterns('',
    url(r'^$', TemplateView.as_view(template_name="index.html"), name='index'),
    url(r'^books$', ListBooks.as_view()),
    url(r'^books/(?P<idBook>[0-9]+)$', InfoBook.as_view()),
    url(r'^books/(?P<idBook>[0-9]+)/order$', SlidesOrder.as_view()),
    url(r'^public', PublicBooks.as_view()),
    url(r'^slides$', ListSlides.as_view()),
    url(r'^slides/(?P<idSlide>[0-9]+)$', InfoSlide.as_view()),
    url(r'^auth/', include('authentication.urls')),
)
