(function(){
	'use strict';

	angular.module('ammicoSlides',['ngResource', 'ngRoute'])
	.controller('slidesCtrl', function($scope, $routeParams, searchApi, $sce){

		$scope.slide = searchApi.slide.get({idSlide:$routeParams.idSlide, format:'json'}, function(data){
			data.details.description =  $sce.trustAsHtml(data.details.description);
		});

		$scope.save = function(){
			$scope.slide.$save({idSlide:$routeParams.idSlide, format:'json'});
		};

	})
	.directive('slideEditor', function() {
		return {
			restrict: 'AE',
			replace: true,
			scope: false,
			templateUrl: 'slides/dataEditor.html',
			controller: function($scope){
				$scope.slidesave = function(){
					if(typeof $scope.slide.tags === 'string'){
						$scope.slide.tags = $scope.slide.tags.split(',');
					}
					for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
						$scope.slide.tags[i] = $scope.slide.tags[i].trim();
					}
					$scope.slide.editMode = false;
					$scope.save();
				};
			}
		};
	});

})();
