(function(){
    'use strict';

    angular.module('ammico', [ 'ngRoute','ammicoHome', 'ammicoMyvisit', 'ammicoBooks', 'ammicoVisites', 'ammicoSlides', 'ammicoSlideshow', 'ammicoSearch', 'ammicoAuth', 'ammicoCommon', 'templates' ])
    .config(function($routeProvider, $httpProvider) {
        $httpProvider.interceptors.push(function($q, $location) {
            return {
                responseError: function(rejection) {
                    if (rejection.status == 401) {
                        localStorage.removeItem('token');
                    }
                    return $q.reject(rejection);
                }
            };
        });
        
        $routeProvider.
        when('/', {
            controller: 'homeCtrl',
            templateUrl: 'home/home.html',
            authRequired: false
        }).
        when('/my_visit', {
            controller: 'my_visitCtrl',
            templateUrl: 'my_visit/my_visit.html',
            authRequired: true
        }).
        when('/books', {
            controller: 'booksCtrl',
            templateUrl: 'books/books.html',
            authRequired: true
        }).
        when('/books/:idBook', {
            controller: 'bookCtrl',
            templateUrl: 'books/book.html',
            authRequired: true
        }).
        when('/visites', {
            controller: 'visitesCtrl',
            templateUrl: 'visites/visites.html',
            authRequired: true
        }).
        when('/visites/:idVisit', {
            controller: 'visiteCtrl',
            templateUrl: 'visites/visite.html',
            authRequired: true
        }).
        when('/slide/:idSlide', {
            controller: 'slidesCtrl',
            templateUrl: 'slides/slides.html',
            authRequired: true
        }).
        when('/slideshow/', {
            controller: 'slideshowCtrl',
            templateUrl: 'slideshow/slideshow.html',
            authRequired: true
        }).
        when('/slideshow/:iSlide', {
            controller: 'slideshowCtrl',
            templateUrl: 'slideshow/slideshow.html',
            authRequired: true
        }).
        when('/search/:q', {
            controller: 'searchCtrl',
            templateUrl: 'search/search.html',
            authRequired: true
        }).
        when('/auth/:action', {
            controller: 'authCtrl',
            templateUrl: 'home/home.html',
            authRequired: false
        }).
        otherwise({
            redirectTo: '/'
        });
    })
    .run( function($rootScope, $location, $window, $http, authApi) {
        $rootScope.globals = {};
        if (localStorage.getItem('token')) {
            $rootScope.globals.userLogged = true;
            $http.defaults.headers.common.Authorization = 'Token ' + localStorage.getItem('token');
        }
        $rootScope.$on( '$routeChangeStart', function(event, next) {
            if (next.authRequired && !$rootScope.globals.userLogged) {
                $location.path( '/auth/login' );
            }
        });
    })
})();
