# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import taggit.managers
import datetime
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('id_article', models.CharField(blank=True, null=True, max_length=512)),
                ('title', models.CharField(blank=True, max_length=512)),
                ('description', models.CharField(blank=True, null=True, max_length=512)),
                ('image', models.URLField(blank=True, max_length=2048)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('public', models.BooleanField(default=False, db_index=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Exposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=512)),
                ('description', models.CharField(blank=True, max_length=1024)),
                ('url_exalead', models.URLField(blank=True, max_length=2048)),
                ('url_orpheo', models.URLField(blank=True, max_length=2048)),
                ('url_jamespot', models.URLField(blank=True, max_length=2048)),
                ('active', models.BooleanField(default=True, db_index=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('id_stop', models.CharField(blank=True, max_length=512)),
                ('id_inventory', models.CharField(blank=True, max_length=512)),
                ('title', models.CharField(blank=True, max_length=512)),
                ('description', models.CharField(blank=True, max_length=1024)),
                ('image', models.URLField(blank=True, max_length=2048)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('favorite', models.BooleanField(default=False, db_index=True)),
                ('book', models.ForeignKey(related_name='slides', to='ammico.Book')),
                ('tags', taggit.managers.TaggableManager(blank=True, to='taggit.Tag', through='taggit.TaggedItem', verbose_name='Tags', help_text='A comma-separated list of tags.')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterOrderWithRespectTo(
            name='slide',
            order_with_respect_to='book',
        ),
        migrations.AddField(
            model_name='book',
            name='exposition',
            field=models.ForeignKey(related_name='exposition', to='ammico.Exposition'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='book',
            name='parent_visit',
            field=models.ForeignKey(blank=True, null=True, to='ammico.Book', related_name='books_copy'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='book',
            name='user',
            field=models.ForeignKey(related_name='books', to=settings.AUTH_USER_MODEL),
            preserve_default=True,
        ),
    ]
