from django.conf.urls import patterns, url, include

from ammico.views import ListBooks, InfoBook, ListSlides, InfoSlide, SlidesOrder, PublicBooks, AmmicoView, api_root


urlpatterns = patterns('',
                       
    url(r'^(?P<idExpo>[0-9]*)$', AmmicoView.as_view(), name='index'),
    url(r'^books$', ListBooks.as_view(), name='books'),
    url(r'^books/(?P<idBook>[0-9]+)$', InfoBook.as_view(), name='book'),
    url(r'^books/(?P<idBook>[0-9]+)/order$', SlidesOrder.as_view(), name='order'),
    url(r'^public', PublicBooks.as_view(), name='publicBooks'),
    url(r'^slides$', ListSlides.as_view(), name='slides'),
    url(r'^slides/(?P<idSlide>[0-9]+)$', InfoSlide.as_view(), name='slide'),
    url(r'^auth/', include('authentication.urls', namespace="authentication")),
    
    url(r'^$', api_root, name='api-root'),
)
