(function(){
	'use strict';

	angular.module('ammicoBooks',['ngRoute', 'ui.sortable'])
	.controller('booksCtrl', function($scope, $location, $modal, ammicoApi){
		$scope.books = ammicoApi.listBooks.query({format:'json'});
		$scope.searchSubmit = function(){
			$location.path('/search/' + $scope.q);
		};
		
		$scope.addBook = function () {
			$modal.open({
				templateUrl: 'books/add_modal.html',
				controller: 'ModalAddBookCtrl'
			});
		};
	})
	.controller('bookCtrl', function($scope, ammicoApi, $routeParams) {
		$scope.slides = ammicoApi.booksSlides.query({idBook:$routeParams.idBook, format:'json'});
		$scope.slides.sort(function (a, b) {
		    return a.orderIndex > b.orderIndex;
		  });
		$scope.sortableOptions = {
		    stop: function() {
		    	var order = $scope.slides.map(function(i){
		            return i.id;
		    	});
		    	ammicoApi.order.save({idBook:$routeParams.idBook}, {order: order});
		    }
		};
		
		$scope.deleteItem = function(i){
			if(0<=i && i<$scope.slides.length){
				if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
					ammicoApi.slide.delete({idSlide: $scope.slides[i].id}, function(){
						$scope.slides.splice(i, 1);
					});
				}
			}
		};
	})
	.controller('ModalAddBookCtrl', function ($scope, ammicoApi, $modalInstance) {
		
		$scope.add = function(){
			ammicoApi.listBooks.save({title: $scope.title});
			$modalInstance.close();
		};

		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
		};
	});
})();
