(function(){
    'use strict';

    angular.module('ammicoVisites',['ngRoute', 'ui.sortable'])
    .controller('visitesCtrl', function($scope, $location, $modal, Book, Slide){

        //get list book
        $scope.visits = Book.query({type: 'visit', format:'json'}, function(data){
            data.sort(function (a, b) {
                return a.date < b.date;
            });

            for (var i = 0; i < data.length; i++) {
                data[i].slides = Slide.query({idBook:data[i].id, limit: 5, format:'json'});
            }    
        });

        $scope.toggleModal = function (index) {

            var modalInstance = $modal.open({
                templateUrl: 'visites/add_book_modal.html',
                controller: 'ModalAddVisitesCtrl',
                size: 'sm'
            });

            modalInstance.result.then(function (idBook) {
                var newSlide = {
                    book: idBook,
                    research_id: $scope.results.hits[index].metas_dict.inventorynumber
                };
                Slide.save(newSlide);
            });
        };


        $scope.addBook = function (idParent) {
            $modal.open({
                templateUrl: 'visites/add_modal_visites.html',
                controller: 'ModalAddVisitesCtrl'
            }).result.then(function (title) {
                //add book with the title written in the modal
                Book.save({idParent:idParent, title: title}, function(newBook){
                    $scope.books.push(newBook);
                });
            });
        };
        
    })


    .controller('visiteCtrl', function($scope, $routeParams, $modal, Book, Slide) {
        //get the slides of a book
      
       $scope.visit = Book.get({idBook:$routeParams.idVisit, format:'json'}, function(data){
           data.slides = Slide.query({idBook: data.id, format:'json'}, function(data){
              data.sort(function (a, b) {
                  return a.orderIndex > b.orderIndex;
              });
          });
       });
       $scope.addBook = function (idParent) {
            $modal.open({
                templateUrl: 'visites/add_modal_visites.html',
                controller: 'ModalAddVisitesCtrl'
            }).result.then(function (title) {
                //add book with the title written in the modal
                Book.save({idParent:idParent, title: title}, function(newBook){
                    $scope.books.push(newBook);
                });
            });
        };
    })


    .controller('ModalAddVisitesCtrl', function($scope, $modalInstance, Book) {

        $scope.add = function(){
            $modalInstance.close($scope.title);
//            ammicoApi.listBooks.save({title: $scope.title}, function(newBook){
//            });
        };
        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        };

        $scope.books = Book.query({format:'json'});
        
        $scope.addToBook = function(idBook){
            $modalInstance.close(idBook);
        };

        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        };

    
    });

})();
