
(function(){
    'use strict';
    
    angular.module('ammicoCommon', ['ngRoute'])
    .factory('Book', function($resource, context) {
        var books = $resource(context.urls.ammicoUrl+'books/:idBook', {idBook:'@id', idExpo: context.idExpo}, {update: { method: 'PUT'}});
        return books;
    })
    .factory('Slide', function($resource, context, $modal) {
        var slides = $resource(context.urls.ammicoUrl+'slides/:idSlide', {idSlide:'@id'}, {update: { method: 'PUT'}});
        
        angular.extend(slides.prototype, {

            toggleFavorite: function () {
                this.favorite = !this.favorite;
                this.$update();
            },
            addToBook: function () {
                var _this = this;
                var modalInstance = $modal.open({
                    templateUrl: 'books/add_book_modal.html',
                    controller: 'ModalAddBookCtrl',
                    size: 'sm'
                });

                modalInstance.result.then(function (idBook) {
                    var newSlide = _this;
                    newSlide.book = idBook;
                    delete newSlide.id;
                    slides.save(newSlide);
                });
            },
            update: function(){
                console.log('test');
            },
            remove: function (array) {
                var _this = this;
                if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
                    this.$delete(function(){
                        if (array){
                            array.splice(array.indexOf(_this), 1);
                        }
                        //$scope.$emit('slideDeleted', array);
                    },
                    function(error) {
                        if (error.status === 404 && array){
                                array.splice(array.indexOf(_this), 1);
                        }
                    });
                }
            }
        });
        
        return slides;
    })
    .factory('Order', function($resource, context) {
        return $resource(context.urls.ammicoUrl+'books/:idBook/order', {idBook:'@id'});
    })
    .service('Utils', function($resource, context, $sce) {
        this.sanitizeUrls = function(data){
            data.details.audio = $sce.trustAsResourceUrl(data.details.audio);
            data.details.video = $sce.trustAsResourceUrl(data.details.video);
            data.audio = $sce.trustAsResourceUrl(data.audio);
            data.video = $sce.trustAsResourceUrl(data.video);
            return data;
        };
    })
    .service('authApi', function($resource, context) {
        this.login = $resource(context.urls.ammicoUrl+'auth/api-token-auth', {idExpo: context.idExpo});
        this.logout = $resource(context.urls.ammicoUrl+'auth/logout');
        this.user = $resource(context.urls.ammicoUrl+'auth/user');
        this.test = $resource(context.urls.ammicoUrl+'auth/auth');
    })
    .service('searchApi', function($resource, context) {
        this.searchResource = function(params){
            return $resource(context.urls.searchUrl,  
                    {
                callback: 'JSON_CALLBACK'
                    },
                    {
                        getJsonp: {
                            method: 'JSONP',
                            params: params,
                            isArray: false,
                            transformResponse: function(data){
                                var i, j;
                                // Transform meta list into meta dict
                                if (typeof data.hits !== 'undefined'){
                                    var nb = data.hits.length;
                                    for(i=0;i<nb;i++){
                                        var nb_metas = data.hits[i].metas.length;
                                        data.hits[i].metas_dict = {};
                                        for(j=0;j<nb_metas;j++){
                                            if(typeof data.hits[i].metas[j].images==='undefined'){
                                                data.hits[i].metas_dict[data.hits[i].metas[j].name] = data.hits[i].metas[j].value;
                                            }
                                            else{
                                                data.hits[i].metas_dict.images = data.hits[i].metas[j].images[0].value;
                                            }
                                        }
                                    }
                                    return data;   
                                }
                                if (typeof data.response !== 'undefined'){
                                    var result = [];

                                    angular.forEach(data.response[0].collect, function(value) {
                                        var temp = {};
                                        angular.forEach(value, function(value2, key2) {
                                            temp[key2]= value2;
                                        });
                                        result.push(temp);
                                    });
                                }
                            }
                        }
                    });
        };
    })
    .directive('imgType', function(){
        return {
            restrict: 'AE',
            link: function(scope, elem) {
                elem.bind('error', function() {
                    elem.parent().addClass('no-img');
                    elem.remove();
                });
                elem.on('load', function() {
                    var w = elem.width(),
                        h = elem.height();
                    if (w > h){
                        elem.addClass('img-landscape');
                    }
                });
            }
        };
    });
    
})();
