(function(){
    'use strict';

    angular.module('ammicoBooks',['ngRoute', 'ui.sortable'])
    .controller('booksCtrl', function($scope, $location, $modal, Book, Slide){
        $scope.editable = true;
        
        $scope.books = Book.query({format:'json'}, function(data){
            data.sort(function (a, b) {
                return a.date < b.date;
            });

            for (var i = 0; i < data.length; i++) {
                if (data[i].idArticle === null){
                    data[i].slides = Slide.query({idBook:data[i].id, limit: 5, format:'json'});
                }
            }
        });

        $scope.toggleModal = function (index) {

            var modalInstance = $modal.open({
                templateUrl: 'books/add_book_modal.html',
                controller: 'ModalAddBookCtrl',
                size: 'sm'
            });

            modalInstance.result.then(function (idBook) {
                var newSlide = {
                    book: idBook,
                    idInventory: $scope.results.hits[index].metas_dict.inventorynumber
                };
                Slide.save(newSlide);
            });
        };

        $scope.addBook = function (idParent) {
            $modal.open({
                templateUrl: 'books/add_modal.html',
                controller: 'ModalAddBookCtrl'
            }).result.then(function (title) {
                Book.save({idParent:idParent, title: title}, function(newBook){
                    $scope.books.push(newBook);
                });
            });
        };
        $scope.deleteItem = function(item){
            if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
                Slide.delete({idSlide: item.id}, function(){
                    $scope.book.slides.splice($scope.book.slides.indexOf(item), 1);
                },
                function(error) {
                    if (error.status === 404){
                        $scope.book.slides.splice($scope.book.indexOf(item), 1);
                    }
                });
            }
        };
        $scope.deleteBook = function(book){
            if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
                Book.delete({idBook: book.id}, function(){
                    $scope.books.splice($scope.books.indexOf(book), 1);
                },
                function(error) {
                    if (error.status === 404){
                        $scope.books.splice($scope.books.indexOf(book), 1);
                    }
                });
            }
        };
    })

    .controller('bookCtrl', function($scope, $location, $routeParams, $modal, Book, Slide, Order) {
        $scope.editable = true;
        
        $scope.book = Book.get({idBook:$routeParams.idBook, format:'json'}, function(data){
            data.slides = Slide.query({idBook: data.id, format:'json'}, function(data){
                data.sort(function (a, b) {
                    return a.orderIndex > b.orderIndex;
                });
            });
        });

        $scope.toggleModal = function (index) {

            var modalInstance = $modal.open({
                templateUrl: 'books/add_book_modal.html',
                controller: 'ModalAddBookCtrl',
                size: 'sm'
            });

            modalInstance.result.then(function (idBook) {
                var newSlide = {
                    book: idBook,
                    idInventory: $scope.results.hits[index].metas_dict.inventorynumber
                };
                Slide.save(newSlide);
            });
        };

        $scope.sortableOptions = {
                stop: function() {
                    var order = $scope.book.slides.map(function(i){
                        return i.id;
                    });
                    Order.save({idBook:$routeParams.idBook}, {order: order});
                }
        };
        
        $scope.deleteItem = function(item){
            if(window.confirm('Êtes-vous sûr(e) de vouloir effacer cet élément ? Cette action est irrémédiable.')){
                Slide.delete({idSlide: item.id}, function(){
                    $scope.book.slides.splice($scope.book.slides.indexOf(item), 1);
                },
                function(error) {
                    if (error.status === 404){
                        $scope.book.slides.splice($scope.book.indexOf(item), 1);
                    }
                });
            }
        };
    })
    .controller('ModalAddBookCtrl', function ($scope, Book, $modalInstance) {

        $scope.add = function(){
            $modalInstance.close($scope.title);
        };
        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        }
        ;
        $scope.books = Book.query({format:'json'});
        
        $scope.addToBook = function(idBook){
            $modalInstance.close(idBook);
        };

        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        };
    });
})();
