(function(){
	'use strict';

	angular.module('ammicoAuth',['ngRoute'])
	.controller('authCtrl', function($rootScope, $routeParams, $modal){
		$modal.open({
			templateUrl: 'auth/' + $routeParams.action + '_modal.html',
			controller: 'auth' + $routeParams.action + 'Ctrl'
		});
	})
	.controller('authloginCtrl', function($modalInstance, $scope, authApi, $window, $http, $location, $rootScope){
		$scope.login = function(){
			authApi.login.save({username:$scope.username, password:$scope.password}, function(data){
				$rootScope.globals.userLogged = true;
				$window.sessionStorage.token = data.token;
				$http.defaults.headers.common.Authorization = 'Token ' + $window.sessionStorage.token;
				$modalInstance.close();
				$location.path('/books');
			});
		};
		$scope.cancel = function () {
			$modalInstance.dismiss('cancel');
			$location.path( '/' );
		};
	})
	.controller('authlogoutCtrl', function($modalInstance, $scope, $window, $http, $location, $rootScope){
		delete $window.sessionStorage.token;
		$rootScope.globals.userLogged = false;
		delete $http.defaults.headers.common.Authorization;
		
		$scope.cancel = function () {
			$modalInstance.close();
			$location.path( '/' );
		};
	})
	.controller('authregisterCtrl', function($scope, $modalInstance, $location){
		$scope.register = function () {
		};
		$scope.back = function () {
			$modalInstance.close();
			$location.path( '/auth/login' );
		};
	});
})();
