from django.conf.urls import patterns, url, include

from ammico.views import ListBooks, InfoBook, ListSlides, InfoSlide, SlidesOrder, PublicBooks, AmmicoView


urlpatterns = patterns('',
    url(r'^$', AmmicoView.as_view(), name='index'),
    url(r'^books$', ListBooks.as_view()),
    url(r'^books/(?P<idBook>[0-9]+)$', InfoBook.as_view()),
    url(r'^books/(?P<idBook>[0-9]+)/order$', SlidesOrder.as_view()),
    url(r'^public', PublicBooks.as_view()),
    url(r'^slides$', ListSlides.as_view()),
    url(r'^slides/(?P<idSlide>[0-9]+)$', InfoSlide.as_view()),
    url(r'^auth/', include('authentication.urls')),
)
