from rest_framework import serializers

from ammico.models import Book, Slide
from ammico.serializers.extractors import extractFromMIMO, extractFromJameSpot
from ammico.serializers.taggit import TaggitSerializer, TagListSerializerField


class BookSerializer(serializers.ModelSerializer):
    count = serializers.SerializerMethodField('getCount')
    
    def getCount(self, book):
        return book.slides.all().count()
    
    class Meta:
        model = Book
        fields = ('id', 'user', 'id_article', 'parent_visit', 'title', 'description', 'image', 'date', 'count', 'public')
        
class SlideSerializer(TaggitSerializer, serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    index = serializers.SerializerMethodField('getOrder')
    tags = TagListSerializerField(required=False)
    
    def getStopInfo(self, slide):
        if (slide.id_inventory != ""):
            #slide added from searched in MIMO database
            return extractFromMIMO(slide)
        else:
            #Get stop info from Oprheo
            #return extractFromOrpheo(slide)
            #Get stop info from Jamespot
            return extractFromJameSpot(slide)
        
    def getOrder(self, slide):
        return slide.book.get_slide_order().index(slide.id)

    class Meta:
        model = Slide
        fields = ('id', 'index', 'book', 'id_stop', 'id_inventory', 'title', 'description', 'image', 'date', 'favorite', 'tags', 'details')