(function(){
  'use strict';

  angular.module('ammicoSlideshow',['ngResource', 'ngRoute', 'ui.bootstrap'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'slideshow/slideshow.html',
          controller: 'slideshowCtrl'
        });
    })
    .service('slideshowApi', function($resource, context) {
      console.log('5',this);
      this.slideshow = $resource(context.urls.slideshowUrl);
    })
    .service('slideshowModel', function(slideshowApi, context) {
      console.log('6',this);
      if(typeof context.slideshow === 'undefined') {
          console.log('6-1');
          this.slideshow = slideshowApi.slideshow.get();
      }
      else {
          console.log('6-2');
          this.slideshow = new slideshowApi.slideshow(context.slideshow);
      }
    })
    .controller('slideshowCtrl', function($scope, $location, $routeParams, slideshowModel){
      console.log('7',$scope, $location, slideshowModel);
      $scope.slideshow = slideshowModel.slideshow;
      $scope.iSlide = parseInt($routeParams.iSlide) || 0;

      $scope.save = function(){
          console.log('8 call save POST',$scope.slideshow);
          $scope.slideshow
          .$save()
          .then(
              function(response) {
                  console.log('NICE SAVING!', response);
              },
              function(reason){
                  alert('An error occured while saving : ' + reason);
              }
          );
      };
    })
    //.directive('slideEditor', function(context) {
    .directive('slideEditor', function() {
      return {
          restrict: 'AE',
          replace: true,
          scope: false,
          templateUrl: 'slideshow/dataEditor.html',
          //controller: function($scope, $element, $attrs){
          controller: function($scope){
              $scope.slidesave = function(){
                  if(typeof $scope.slide.tags === 'string'){
                      $scope.slide.tags = $scope.slide.tags.split(',');
                  }
                  for (var i = $scope.slide.tags.length - 1; i >= 0; i--) {
                      $scope.slide.tags[i] = $scope.slide.tags[i].trim();
                  }
                  $scope.editMode = false;
                  $scope.save();
              };
          }
      };
  });

})();
