(function(){
  'use strict';

  angular.module('ammicoSearch',['ngResource', 'ngRoute'])
    .config(function ($routeProvider) {
      $routeProvider
        .when('/', {
          templateUrl: 'search/search.html',
          controller: 'searchCtrl'
        });
    })
    .service('searchApi', function($resource, context) {
        console.log('search 4',$resource, context);
        this.searchResource = function(params){
            return $resource(context.urls.searchUrl,  
                {
                    callback: 'JSON_CALLBACK'
                },
                {
                    getJsonp: {
                        method: 'JSONP',
                        params: params,
                        isArray: false
                    }
                });
        };
        
    })
    .service('searchModel', function(searchApi) {
        console.log('search 5');
        this.searchResults = function(params){
            return searchApi.searchResource(params).getJsonp();
        };
    })
    .controller('searchCtrl', function($scope, $location, $routeParams, searchModel){
      console.log('search 6',$scope, $location, $routeParams);
      $scope.q = $routeParams.q || '';
      searchModel.searchResults({q:$scope.q, of: 'json', synthesis: 'false', callback: 'JSON_CALLBACK'}).$promise.then(
          //success
          function( data ){
              console.log('SUCCESS !', data);
              $scope.results = data;
          },
          //error
          function( error ){
              console.log('ERROR !', error);
          }
      );
      //window.myres = res;
      //$scope.results = res;
      //console.log('search 6-blabla', res);
      console.log('search 7', $scope.q);
      
      //$scope.search = searchModel.search;
      // query = ?q=violon&of=json&synthesis=false
    })
    .filter('meta', function() {
        return function(input, metaName) {
            var nb = input.length, i = 0, found = false;
            while(found===false && i<nb){
                if(input[i].name===metaName){
                    found = true;
                    return input[i].value;
                }
                i++;
            }
        };
    });

})();
