from rest_framework import serializers
from .models import Book, Slide
from ammico.utils import fetchJson


class BookSerializer(serializers.ModelSerializer):

    class Meta:
        model = Book
        fields = ('id', 'idArticle', 'title', 'description', 'image', 'date')
        
class SlideSerializer(serializers.ModelSerializer):
    details = serializers.SerializerMethodField('getStopInfo')
    
    def getStopInfo(self, slide):
        stopList = fetchJson('http://fui-ammico.jamespot.pro/api/api.php?&k=6c8bfcea247e8a5841288269887d88f0&d=2016-01-31&m=EXT-IRI&v=2.0&f=list&o=article&type=stop&itemFormat=article')
        #print (stopList) 
        for stops in stopList:
            if (slide.idStop == stops['idStop']):
                return stops 

    class Meta:
        model = Slide
        fields = ('id', 'book', 'idStop', 'title', 'description', 'comment', 'image', 'date', 'favorite', 'details')