# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AmmicoUser',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('idUser', models.CharField(unique=True, max_length=512)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('user', models.ForeignKey(to=settings.AUTH_USER_MODEL)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('idArticle', models.CharField(unique=True, max_length=512)),
                ('title', models.CharField(max_length=512, blank=True)),
                ('description', models.CharField(max_length=512, null=True, blank=True)),
                ('image', models.URLField(max_length=2048, blank=True)),
                ('date', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(to='ammico.AmmicoUser')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('idStop', models.CharField(max_length=512)),
                ('comment', models.CharField(max_length=512, blank=True)),
                ('date', models.DateTimeField(blank=True)),
                ('favorite', models.BooleanField(default=False, db_index=True)),
                ('book', models.ForeignKey(to='ammico.Book')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
    ]
